define(['modules/notification-info/notification-info-popup-view'], function(NotificationInfoPopupView) {
    'use strict';

    describe('Notification Info Popup', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            view = new NotificationInfoPopupView({
                elAfterClose: '.element-for-focus',
                isForCommunityCare: true,
            });
            $('body').append('<a class="element-for-focus" href="#"></a>');
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        describe('JSON data is not empty and', function() {
            beforeEach(function() {
                view.render();
                $view = view.$el;
            });

            it('has a heading', function() {
                expect($view.find('h2.ui-title').text()).toEqual('Appointment and Request Updates');
            });

            it('has a information about notifications', function () {
                expect($view.find('.ui-content p:first-of-type').text())
                    .toEqual('When you opt in to receive appointment and request updates, you will receive the following notifications: ');
                expect($view.find('.ui-content li:first-of-type').text())
                    .toEqual('Request Status Updates: These updates are sent each time the status to your request changes. For example, ' +
                        'when your request changes from a "Submitted" status to a "Scheduled" status you will be notified of that status change.');
                expect($view.find('.ui-content li:nth-of-type(2)').text())
                    .toEqual('Community Appointment Reminders: Reminders about upcoming appointments with community' +
                        ' providers are sent during the week prior to the appointment as well as on the appointment day.');
            });

            it('has an OK button', function() {
                var loginBtn = $view.find('#notification-info-ok-btn');
                expect(loginBtn.text()).toEqual('OK');
            });
        });

        describe('JSON data is empty and', function() {
            beforeEach(function() {
                spyOn(view, 'templateContext').and.returnValue({ notificationInfo: []});

                view.render();
                $view = view.$el;
            });

            it('does not have information about notifications', function() {
                expect($view.find('.ui-content li').length).toEqual(0);
            });
        });
    });
    describe('JSON data only has VA data which', function() {
        var view;
        var $view;
        beforeEach(function () {
            view = new NotificationInfoPopupView({
                elAfterClose: '.element-for-focus',
            });
            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function () {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a information about notifications', function () {
            expect($view.find('.ui-content p:first-of-type').text())
                .toEqual('When you opt in to receive appointment and request updates, you will receive the following notifications: ');
            expect($view.find('.ui-content li:first-of-type').text())
                .toEqual('Request Status Updates: These updates are sent each time the status to your request changes. For example, ' +
                    'when your request changes from a "Submitted" status to a "Scheduled" status you will be notified of that status change.');
            expect($view.find('.ui-content li:nth-of-type(2)').text()).toBeFalsy();
        });

    });
});

